$(document).ready(function () {
    // Variables nécessaires à la communication avec la carte Arduino
    let delaiMesure = 8000;
    let delaiError = 6000;

    // Etape 1. Fixer des coordonnées initiales sur la carte : celles du lycée Pierre Emile Martin - Bourges
    let initLatitude = 47.074062128748594;
    let initLongitude = 2.4053724646567654;
    let zoom = 11;

    // Etape 2. Créer et initialiser la carte
    let map = L.map('map').setView([initLatitude, initLongitude], zoom);

    // 3. Ajouter un calque de tuiles à la carte
    // Source des tuiles : OpenStreetMap
    /*L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(map);*/

    // ou source des tuiles : mapbox (nécessite un jeton)
    L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token={accessToken}', {
        attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>',
        maxZoom: 19,
        id: 'mapbox/streets-v11',
        tileSize: 512,
        zoomOffset: -1,
        accessToken: 'pk.eyJ1Ijoid2ViZ2UiLCJhIjoiY2wxZ2p2Yno4MHZ0ejNncnRmNzNxZW45MyJ9.xTlsFgrSafNbS3ysCaU7HA'
    }).addTo(map);

    // Etape 4. Ajouter un marqueur sur la carte
    let marker = L.marker([initLatitude, initLongitude]).addTo(map);

    // Etape 5. Gérer la communication avec la carte Arduino
    function loadCoordinates() {
        let latitude;
        let longitude;

        $.ajax({
            url: 'scripts/lireval0et1.php',
            type: 'get',
            dataType: 'json',
            success: function (data) {
                $.each(data, function (entryIndex, entry) {
                    // Pour les tests, on souhaite 0 < val0 < 1000 => 47.07970 < latitude < 47.01328
                    latitude = -0.0000664 * parseFloat(entry.val0) + 47.07970;
                    // Pour les tests, on souhaite 0 < val1 < 1000 => 2.199468 < longitude < 2.409102
                    longitude = 0.000210 * parseFloat(entry.val1) + 2.199468;

                    // Afficher les valeurs numériques
                    $('#latitude').html(latitude);
                    $('#longitude').html(longitude);

                    // Afficher un marqueur sur la carte (objet map)
                    map.flyTo([latitude, longitude], zoom, {
                        animate: true,
                        duration: 2 // en secondes
                    });
                    marker = L.marker([latitude, longitude]).addTo(map);
                })
            },
            timeout: delaiError,
            error: function () {
                // pour aller plus loin
            }
        });
    }

    loadCoordinates(); // premier appel de la fonction

    setInterval(function () { // appel de la fonction toutes les delaiMesure ms
        loadCoordinates()
    }, delaiMesure);
});